<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/ /** */

require_once 'Object.php';
require_once APPPATH.'models/message.php';

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
* @todo - separate patient document methods into a child class
*/
class Attachment extends Object{
	protected $name; //the actual name + extension: e.g. 'myfile.txt', without the full path
	protected $_directory; //the full path EXCLUDING the filename: i.e. /www/htdocs/, not /www/htdocs/myfile.txt.  Will always have a trailing slash.
	protected $_binary_string;
	protected $_message_id;

	protected $_filetype;
	protected $_extension;
	protected $_cid;
	protected $_url;
	protected $_html_friendly_name; //a version of the file name that will be appropriate for form names and css classes

	protected $_property_validation_rules= array( 'binary_string' => 'string',
												  'extension' => 'string_with_no_whitespace',
												  'filetype' => 'string_with_no_whitespace',
												  'name' => 'string_like_a_file_path',
												  'cid' => 'nonempty_string',
												  'url' => 'string_like_a_url',
												 );

	function classes(){
		$classes = array_merge( array(get_class($this) => get_class($this)), class_parents($this));
		unset($classes['Object']);
		return array_map('make_string_css_friendly', $classes);
	}

	//describe this attachment for error messages - analogous to Entity::describe()
	function describe(){
		if(Message::formatted_like_an_id($this->message_id))
			return strtolower(humanize(get_class($this))).' for message#'.$this->message_id.' '.$this->error->describe($this->name);
		if(!$this->property_is_empty('directory'))
			return $this->error->describe($this->path());
		return strtolower(humanize(get_class($this))).' '.$this->error->describe($this->name);
	}

	function download(){
		if($this->property_is_empty('name')) return $this->error->warning("Can't set up download without a name for this file.");
		header("Content-Type: application/force-download");
		header("Content-Disposition: attachment; filename=\"" . $this->name . "\"");
		header("Content-Transfer-Encoding: binary");
		echo $this->binary_string; //note - in some places in the code, we ran base-64 on this in the past.
	}

	function url_for_view(){
		if(Message::formatted_like_an_id($this->message_id))
			return site_url('inbox/message/'.$this->message_id.'/attachments/'.rawurlencode($this->name));
		return site_url('inbox/compose/draft/attachments/'.rawurlencode($this->name));
	}
	
	//method for providing the "base url" needed to preview pdfs within pdf.js
#TODO - THIS SHOULD EXIST ONLY WITHIN PDF_ATTACHMENT.PHP - ONCE WE REFACTOR LINK(), MOVE THIS	
	function url_for_preview(){
		$pdfjs_url = site_url('jscripts/pdfjs/web/viewer.html');
		if(Message::formatted_like_an_id($this->message_id)){
			$url_for_preview = $pdfjs_url."?file=".rawurlencode(site_url('inbox/message/'.$this->message_id.'/attachments/view/inline/'.rawurlencode($this->name)));
		}
		else{
			$url_for_preview = $pdfjs_url."?file=".rawurlencode(site_url('inbox/compose/draft/attachments/view/inline/'.rawurlencode($this->name)));
		}
		return $url_for_preview;
	}

	function url_for_download(){
		if(Message::formatted_like_an_id($this->message_id))
			return site_url('inbox/message/'.$this->message_id.'/attachments/download/'.rawurlencode($this->name));
		return site_url('inbox/compose/draft/attachments/download/'.rawurlencode($this->name));
	}

#TODO - REALLY NEED TO SPLIT THIS UP INTO SMALLER METHODS SO THAT CHILD CLASSES CAN OVERLOAD AND WE CAN STOP VIOLATING OOP PRINCIPLES
	function link($text=null, $attributes = array()){
		if(is_null($text)) $text = $this->name;
		$attributes = merge_attributes(array('class' => implode(' ', $this->classes), 'title' => $this->name), $attributes);
		$security_token = get_instance()->security->get_csrf_token_name().'='.get_instance()->security->get_csrf_hash();
		$url = $this->url_for_view().'?'.$security_token;

		//this should really be done via inheritance -- clean up later or just remove once we start lightboxing pdfs
		if($this->extension == 'pdf' || (USE_DOC_TO_PDF_CONVERSION_PROCESS && is_a($this, 'Word_attachment'))){
			$url = $this->url_for_preview().'?'.$security_token;
			$attributes = merge_attributes(array('class' => 'lightbox iframe'), $attributes);
		}elseif(method_exists($this, 'view') && !is_a($this, 'Word_attachment')){
			$default_attributes = array('class' => 'lightbox');
			if(is_a($this, 'Image_attachment'))
				$default_attributes['rel'] = 'gallery'; //only images should be part of the gallery - documents have scrolling problems

			$attributes = merge_attributes($default_attributes, $attributes);
		}else{
			$url = $this->url_for_download();
		}

		return link_to_url($url, $text, $attributes);
	}


////////////////////
// GETTERS
////////////////////

#TODO -> do we need to update this if they supply content?
	function binary_string(){
		if(isset($this->_binary_string)) return $this->_binary_string;
		if(!empty($this->path())){
			if(!file_exists($this->path())) $this->error->warning('Unable to find file: '.$this->path());
			$this->_binary_string = file_get_contents($this->path());
			return $this->_binary_string;
		}
		return $this->error->warning('No binary string has been set');
	}

	function bytes(){
		if(!empty($this->path()) || isset($this->binary_string)) return string_length_in_bytes($this->binary_string);
		return 0; //file doesn't have a path or a binary string, so its current size is 0
	}

	function extension(){
		if(!isset($this->_extension)) $this->_extension = strtolower(pathinfo($this->name, PATHINFO_EXTENSION));
		return $this->_extension; //we may have grabbed an extension from a mime for an attached file, so we may have better info than just the filename
	}

	function hash(){
		if(!$this->property_is_empty('binary_string'));
		return sha1($this->binary_string);
	}

	function html_friendly_name(){
		return make_string_css_friendly($this->name);
	}

	function filetype(){
		if(!isset($this->filetype)) return $this->extension;
		$this->_filetype;
	}

	function filename(){
		return $this->name;
	}

	function metadata(){
		$properties = array_keys(get_object_vars($this));
		foreach($properties as &$property)
			$property = strip_from_beginning('_', $property);

		$properties = array_merge(array_diff($properties, array('is', 'validator', 'error', 'property_validation_rules', 'binary_string', 'parser')), array('bytes', 'path', 'url'));

		$metadata = array();
		$only_if_not_empty = array('message_id', 'cid', 'das_save_date', 'schema', 'description', 'url');
		foreach($properties as $property){
			$property = strip_from_beginning('_', $property);
			if(!in_array($property, $only_if_not_empty) || !$this->property_is_empty($property)){
				$metadata[$property] = $this->$property;
			}
		}

		return $metadata;
	}

	//the full path of the directory + filename; will only be supplied if both directory path and name has been populated
	function path(){
		if(isset($this->directory) && isset($this->name)){
			return $this->directory.$this->name;
		}
	}

	//deprecated alias for binary_string
	function string(){
		return $this->binary_string;
	}

	function url(){
		return $this->url_for_view();
	}


//////////////////////
// SETTERS
//////////////////////

	//ensure that the path value always has a trailing slash && that the directory exists
	function set_directory($value){
		if(!$this->is->directory_path($value)) return $this->error->property_value_should_be_an_existing_directory_path('directory', $this, $value);
		$this->_directory = strip_from_end('/', $value).'/'; //make sure we always have a trailing slash, but only one
	}


	function set_message_id($value){
		if(!Message::formatted_like_an_id($value)) return $this->error->property_value_should_be_a_message_id('message_id', $this, $value);
		$this->_message_id = $value; //we could check to see if the message really exists, but that would be expensive (API call) - we'll trust the developers in this case
	}

/////////////////////
// STATIC FUNCTIONS
/////////////////////

	public static function create($name, $binary_string, $more_values = array()){
		require_once APPPATH.'libraries/attachments/image_attachment.php';
		require_once APPPATH.'libraries/attachments/pdf_attachment.php';
		require_once APPPATH.'libraries/attachments/word_attachment.php';
		require_once APPPATH.'libraries/attachments/xml_attachment.php';

		foreach(array('Image_attachment', 'PDF_attachment', 'Word_attachment', 'XML_attachment') as $child_class){
			if($child_class::matches_file($name, $binary_string)){
				return $child_class::create($name, $binary_string, $more_values);
			}
		}

		return new Attachment(array_merge(compact('name', 'binary_string'), $more_values));
	}

	public static function matches_file($name, $binary_string){
		return true; //maybe make sure that the name is a valid file name and the binary string isn't empty
	}

}
?>